$(function () {
    listarCategorias();
    listAllProductos();
    fueraservicioadmin();
    listarSedes();
  });
  
  let carrito = [];
  document.addEventListener("DOMContentLoaded", () => {
    carrito = JSON.parse(localStorage.getItem("pedido")) || [];
    $.each(carrito.items, function (ind, elem) {
      pedido.registrar({
        area_id: elem.area_id,
        producto_id: elem.producto_id,
        producto: elem.producto,
        presentacion: elem.presentacion,
        cantidad: elem.cantidad,
        precioProducto: elem.precioProducto,
        precio: elem.total,
        comentario: elem.comentario,
        detalletopico: elem.detalletopico,
        preciotopico: elem.preciotopico,
      });
    });
    elementosCarrito();
  });
  
  function listarCategorias() {
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: { listCateg: 1 },
      success: function (data) {
        $('#list-catgrs').html("<li class='list-group-item'><a href='#' class='textmayus' onclick='listAllProductos()'><p>Todos</p></a></li>");
        $('#list-catgrs').append(data);
      }
    });
  }
  
  $('body').delegate('.page', 'click', function (e) {
    $('.page-item').removeClass('active');
    e.preventDefault();
    var pno = $(this).attr('page');
    var id_catge = $("#id_catge").val();
    if (id_catge == 0) {
      $.ajax({
        url: "../landing/action.php",
        method: "POST",
        data: { listAllProduct: 1, setPage: 1, pageNumber: pno },
        success: function (data) {
          if (data) {
            $("#producto-list").empty();
            $("#producto-list").append(data);
            $('.aqui' + pno).addClass('active');
          } else {
            $("#producto-list").html(
              '<div class="col"><div class="card"><div class="row no-gutters d-flex justify-content-center">No se encontraron resultados</div></div></div>'
            );
          }
        }
      });
    } else {
      $.ajax({
        url: "../landing/action.php",
        method: "POST",
        data: { listProductCateg: 1, id_catg: id_catge, setPage: 1, pageNumber: pno },
        success: function (data) {
          if (data) {
            $("#producto-list").empty();
            $("#producto-list").append(data);
            $('.aqui' + pno).addClass('active');
          } else {
            $("#producto-list").html(
              '<div class="col"><div class="card"><div class="row no-gutters d-flex justify-content-center">No se encontraron resultados</div></div></div>'
              //<div class="text-center"><h4 class="ich m-t-none" style="color: #d3d3d3;"><br><br><br><br><br><br><br><br><br><i class="mdi mdi-star-circle display-4"></i><br>No se han encontrado resultados</h4></div>'
            );
          }
        }
      });
    }
  
  });
  
  function listAllProductos() {
    $("#producto-list").empty();
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: {
        listAllProduct: 1
      },
      success: function (data) {
        if (data) {
          $("#producto-list").append(data);
          page(0);
        } else {
          $("#producto-list").html(
            '<div class="col"><div class="card"><div class="row no-gutters d-flex justify-content-center">No se encontraron resultados</div></div></div>'
          );
        }
      },
    });
  
  }
  
  function listarProductosCateg(id_catg) {
    $("#producto-list").empty();
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: {
        listProductCateg: 1,
        id_catg: id_catg,
      },
      success: function (data) {
        if (data) {
          $("#producto-list").append(data);
          $("#pageno").empty();
          page(id_catg);
        } else {
          $("#producto-list").html(
            '<div class="col"><div class="card"><div class="row no-gutters d-flex justify-content-center">No se encontraron resultados</div></div></div>'
          );
        }
      },
    });
  };
  
  
  /****Paginación *************/
  function page(id_catg) {
    //var divs = document.getElementsByClassName("conteocontenedor").length;
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: { page: 1, catd: id_catg },
      success: function (data) {
        if (data) {
          $('#pageno').html(data);
        } else {
          console.log("");
        }
      }
    })
  }
  
  /****Paginación *************/
  /***********CARRITO************ */
  
  let pedido = {
    detalle: {
      cod_ped: 0,
      items: [],
    },
  
    /* Encargado de agregar un producto a nuestra colección */
    registrar: function (item) {
      var existe = false;
      // console.log(item.cantidad);
      item.total = item.precio;
      this.detalle.items.forEach(function (x) {
        if (x.producto_id === item.producto_id) {
          x.precio = item.precio;
          x.cantidad += item.cantidad;
          x.total += item.total;
          x.preciotopico += item.preciotopico;
          x.detalletopico += "," + item.detalletopico;
          x.comentario += "," + item.comentario;
          existe = true;
        }
      });
  
      if (!existe) {
        this.detalle.items.push(item);
      }
      this.refrescar();
    },
  
    /* Encargado de retirar el producto seleccionado */
    retirar: function (id) {
      /* Declaramos un ID para cada fila */
      $(this.detalle.items).each(function (indice, fila) {
        if (indice == id) {
          pedido.detalle.items.splice(id, 1);
          return false;
        }
      });
      this.refrescar();
    },
  
    /* Refresca todo los productos elegidos */
    refrescar: function () {
      this.detalle.total = 0;
  
      /* Declaramos un id y calculamos el total */
      $(this.detalle.items).each(function (indice, fila) {
        pedido.detalle.items[indice].id = indice;
        pedido.detalle.total += fila.total;
      });
  
      /* Calculamos el subtotal e IGV */
      this.detalle.igv = (this.detalle.total * 0.18).toFixed(2); // 18 % El IGV y damos formato a 2 deciamles
      this.detalle.subtotal = (this.detalle.total - this.detalle.igv).toFixed(2); // Total - IGV y formato a 2 decimales
      this.detalle.total = this.detalle.total.toFixed(2);
  
      elementosCarrito();
    },
  };
  
  /**************MODAL DETALLE PRODUCTO****************** */
  var modalProducto = function (
    id_areap,
    id_pres,
    pro_nom,
    pres_prod,
    imagen,
    precio_prod
  ) {
  
    $('#exampleModal').modal('show');
    $("#detalleProducto").html(
      '<input type="hidden" required id="id_areap" value="' + id_areap + '">' +
      '<input type="hidden" required id="id_pres" value="' + id_pres + '">' +
      '<input type="hidden" required id="pro_nom" value="' + pro_nom + '">' +
      '<input type="hidden" required id="pres_prod" value="' + pres_prod + '">' +
      '<input type="hidden" required id="precio_prod" value="' + precio_prod + '">' +
      '<input type="hidden" required id="precio_cant" value="' + precio_prod + '">' +
      '<input type="hidden" required id="precio_total" value="' + precio_prod + '">' +
      '<div class="row no-gutters d-flex justify-content-center align-items-center contenedor-fila-menu">' +
      '<div class="col-2 col-md-2">' +
      '<img src="https://software.tusistema.pe/public/images/productos/' + imagen + '" class="card-img-top" alt="Imagen del menú"></div>' +
      '<div class="col-6 col-md-8">' +
      '<div class="card-body textmayus">' +
      '<h5 class="card-title mb-0" id="nomproduc"><p style="font-weight: bold; font-size:20px;">' + pro_nom + '</p></h5>' +
      '<p class="card-text mb-0"><span class="bg-warning" style="font-size:13px; padding:3px; border-radius:50px;">' + pres_prod + '</span></p>' +
      '</div>' +
      '</div>' +
      '<div class="col-4 col-md-2">' +
      '<div class="card card2">' +
      '<div class="d-flex  align-items-center">' +
      '<div class="precio">' +
      '<h6 class="card-subtitle mb-0 ">S/' + precio_prod.toFixed(2) + '</h6>' +
      '</div>' +
      '</div>' +
      '</div>' +
      '</div>' +
      '</div>' +
      '<hr class="modal-divider">'
    );
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: { notalist: 1, id_pres: id_pres },
      success: function (data) {
        $("#detalleProducto").append('<h2 class="modal-title fs-5" id="exampleModalLabel">Notas</h2>');
        var arreglo1 = data.split(',');
        if (data.length > 0) {
          $.each(arreglo1, function (ind, elem) {
            $("#detalleProducto").append(
              $('<div class="form-check textmayus" style="display: inline-block; margin-right: 10px;"/>').html(
                '<input type="checkbox" class="chec form-check-input" id="' +
                elem + '" name="checks[]" value="' + elem + '">' + '<label for="' + elem +
                '" class="form-check-label"><p>' + elem + "</p></label>"
              )
            );
          });
        }
        $.ajax({
          url: '../landing/action.php',
          method: 'POST',
          data: { topiclist: 1, id_pres: id_pres },
          success: function (data) {
            $("#detalleProducto").append('<h2 class="modal-title topico-title fs-5" id="exampleModalLabel">Tópicos</h2>');
            if (data) {
              $("#detalleProducto").append(data);
            } else {
              $("#detalleProducto").append('<div class="form-check d-flex align-items-center container">' +
                '<div class="col-12 text-center">Topicos no disponible en este producto</div></div>');
            }
            $("#detalleProducto").append('<hr class="modal-divider"><div class="total-container">' +
              '<h2 class="modal-title fs-5" id="exampleModalLabel">Total</h2>' +
              '<span class="text-end total" id="totalProduct">S/' + precio_prod.toFixed(2) + '</span>' +
              '</div><input type="hidden" id="topicopadre" value=""/><input type="hidden" id="detatopico" name="detatopico" /><input type="hidden" id="detanota" name="detanota" />');
          }
        });
      }
    });
    $("#3").val("1");
  };
  /*************SELECIONANDO TOPICO DEL MODAL PRODUCTO*******************/
  $(".modal-body").on("change", "input.checkkk", function (event) {
    var arr = $('[name="check[]"]:checked')
      .map(function () {
        return this.value;
      })
      .get();
    var str = arr.join(",");
    $("#topicopadre").val(str);
    precioProducto();
    var elemento = $('[name="check[]"]:checked');
    var cantidad = elemento.length;
    var array_id = Array();
  
    for (var i = 0; i < cantidad; i++) {
      var id = elemento[i].getAttribute('id');
      array_id.push(id);
    };
    var strr = array_id.join(",");
    $("#detatopico").val(strr);
  
  });
  
  /*********SELECIONANDO NOTA DEL MODAL PRODUCTO****************/
  $(".modal-body").on("change", "input.chec", function (event) {
    var arr = $('[name="checks[]"]:checked')
      .map(function () {
        return this.value;
      })
      .get();
    var str = arr.join(",");
    $("#detanota").val(str);
  
  });
  
  /***MODIFICA PRECIO EN EL MODAL ya sea se agregue el topico o la cantidad***/
  function precioProducto() {
    //modificando el total
    var precioproduct = $("#precio_prod").val();
    var precio_cant = $("#precio_cant").val();
    var precio_total = $("#precio_total").val();
    var arreglo1 = $("#topicopadre").val().split(",");
    var topicoPrecio = 0;
  
    $.each(arreglo1, function (ind, elem) {
      if (!isNaN(parseFloat(elem))) {
        topicoPrecio += parseFloat(elem);
      }
    });
    var totalprecio = (parseFloat(precio_cant) + topicoPrecio);
    $("#totalProduct").html('S/' + totalprecio.toFixed(2));
    $("#precio_total").val(totalprecio);
  };
  
  function precioProductoCantidad(numero) {
    //modificando el total
    var precioproduct = $("#precio_prod").val();
    var precio_cant = $("#precio_cant").val();
    var precio_total = $("#precio_total").val();
    var nun;
    if (numero) {
      nun = numero;
    } else {
      nun = 1;
    }
    var precioCantidad = (parseFloat(precioproduct) * nun);
    var precioTotal = (parseFloat(precioproduct) * nun) + (parseFloat(precio_total - precio_cant));
    $("#totalProduct").html('S/' + precioTotal.toFixed(2));
    $("#precio_cant").val(precioCantidad);
    $("#precio_total").val(precioTotal);
  };
  
  
  /**************MODAL DETALLE PRODUCTO****************** */
  /**********CARRITO***************** */
  
  $("#btnAccionPedido").click(function () {
    var id_areap = $("#id_areap").val();
    //console.log(id_areap);
    var id_pres = $("#id_pres").val();
    var pro_nom = $("#pro_nom").val();
    var pres_prod = $("#pres_prod").val();
    var precio_prod = $("#precio_prod").val();
    var cant = $("#3").val();
    addCarrito(id_areap, id_pres, pro_nom, pres_prod, precio_prod, cant);
    $('#exampleModal').modal('hide')
  });
  
  var addCarrito = function (
    id_areap,
    id_pres,
    pro_nom,
    pres_prod,
    precio_prod,
    cant
  ) {
    var preciototal = $("#precio_total").val();
    //console.log(preciototal);
    var arreglo1 = $("#topicopadre").val().split(",");
    var topicoPrecio = 0;
    $.each(arreglo1, function (ind, elem) {
      if (!isNaN(parseFloat(elem))) {
        topicoPrecio += parseFloat(elem);
      }
    });
    //var totalprecio = (parseFloat(precioproduct) + topicoPrecio);
    pedido.registrar({
      area_id: id_areap,
      producto_id: parseInt(id_pres),
      producto: pro_nom,
      presentacion: pres_prod,
      cantidad: parseInt(cant),
      precioProducto: parseFloat(precio_prod).toFixed(2),
      precio: parseFloat(preciototal),
      comentario: $("#detanota").val(),
      detalletopico: $("#detatopico").val(),
      preciotopico: topicoPrecio,
    });
  
    elementosCarrito();
  };
  
  function elementosCarrito() {
    //$(".clausulas").empty();
    var arr = pedido.detalle.items;
    $(".clausulas").html('');
    if (!Array.isArray(arr) || arr.length === 0) {
      localStorage.clear();
      $('.buttonsoli').removeClass('btncolor');
      $(".buttonsoli").prop('disabled', true);
      $(".clausulas").html(
        '<span class="mb-0">Añadir elementos de menú a su carrito.</span>'
      );
    } else {
      $(pedido.detalle.items).each(function (indice, fila) {
        $(".clausulas").append(
          '<div class="row align-items-center mt-3">' +
          '<div class="col-2 button-quitar">' +
          '<button type="button" onclick="pedido.retirar(' + pedido.detalle.items[indice].id + ')" class="btn btn-outline-primary">-</button>' +
          '</div>' +
          '<div class="col-7 ">' +
          '<div class="textmayus">' +
          '<h2 class="fw-bold modal-title"><p style="font-weight: bold; font-size:20px;">' + pedido.detalle.items[indice].producto + '</p></h2>' +
          '<p class="card-text mb-0"><span class="bg-warning" style="font-size:13px; padding:3px; border-radius:50px;">' + pedido.detalle.items[indice].presentacion + '</span></p>' +
          '</div>' +
          '<span class="menu-info flex-grow-1">' + pedido.detalle.items[indice].cantidad + ' unidad(es) en S/ ' + pedido.detalle.items[indice].precioProducto + ' | Unidad</span>' +
          '</div>' +
          '<div class="col-3">' +
          '<h2 class="fw-bold modal-title">S/ ' + pedido.detalle.items[indice].total.toFixed(2) + '</h2>' +
          '</div>' +
          '</div>' +
          '<hr class="modal-divider">'
        );
      });
        $(".clausulas").append('<div class="row align-items-center justify-content-between mt-3 contenedor-subtotales">' +
          '<div class="col-7">' +
          '<h2 class="mb-0 pedido-sub">Total del pedido:</h2>' +
          '</div>' +
          '<div class="col-5 text-end">' +
          '<span class=" modal-title">S/ ' + pedido.detalle.total + '</span>' +
          '</div>' +
          '</div>');
      //}
      $('.buttonsoli').addClass('btncolor');
      $(".buttonsoli").prop('disabled', false);
      guardarStorage();
    }
  
  }
  
  function listarSedes() {
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: { listSedeEmpresa: 1 },
      success: function (data) {
        $("#sede").append(data)
      }
    });
  }

  function listarSalon() {
    var idsede = $("#sede").val();
    $("#salon").empty();
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: { listSalonEmpresa: 1, idsede:idsede },
      success: function (data) {
        $("#salon").append(data);
        listarMesa();
      }
    });
  }

  function listarMesa() {
    var idsalon = $("#salon").val();
    $("#mesa").empty();
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: { listMesaEmpresa: 1, idsalon:idsalon },
      success: function (data) {
        $("#mesa").append(data)
      }
    });
  }

  /*******GUARDAR PEDIDO[] EN UNA VARIABLE SESSION************/
  function guardarStorage() {
    localStorage.setItem("pedido", JSON.stringify(pedido.detalle));
  }
  
  /**********BUSCAR PRODUCTO***************** */
  $("#buscarproducto").on("keyup", function () {
    var buscando = $("#buscarproducto").val();
    $("#producto-list").empty();
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: {
        listAllProduct: 1, busca: buscando,
      },
      success: function (data) {
        $("#producto-list").empty();
        if (data) {
          $("#producto-list").append(data);
          page(0);
        } else {
          $("#producto-list").html(
            '<div class="col borrame"><div class="card"><div class="row no-gutters d-flex justify-content-center">No se encontraron resultados</div></div></div>'
          );
        }
      },
    });
  
  });
  
  /**********FIN BUSCAR PRODUCTO************** */
  
  /*****SOLICITAR PEDIDO ****************************/
  $("#solipedido").click(function () {
      showTab('tab2');
      $("#totalsolicitarpedido").val(1);
      listarSalon();
      elementosCarrito();
  });
  
  //***************Boton Aumentar pedido*****************/
  function cantidad(id_input, operacion) {
    var numero = $('#' + id_input).val();
    if (operacion == '1') {
      numero++;
      precioProductoCantidad(numero);
    } else {
      numero--;
      precioProductoCantidad(numero);
    }
  
    if (numero <= 0) {
      numero = 1;
    }
    $('#' + id_input).val(numero);
  }
  
  
  /****************Listar Mis pedidos*****************/
  function mispedidos() {
    var idcliente = $("#id_cliente").val();
    const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 1500,
      timerProgressBar: true,
      didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
      }
    })
    Toast.fire({
      icon: 'success',
      title: 'Listando Pedidos'
    }).then((result) => {
      $.ajax({
        url: '../landing/action.php',
        method: 'POST',
        data: {
          mispedidos: 1, idcliente: idcliente
        },
        success: function (data) {
          $("#mispedidos").html(data);
        },
      });
    })
  
  }
  
  function verPedidoDetalle(idpedido, total) {
    var codatencion = 3; //delivery
    var id_pedido = idpedido;
    $('#modalDetallePedido').modal('show');
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: {
        detallepedido: 1, id_pedido: id_pedido
      },
      success: function (data) {
        $("#pedidodetalle").html(data);
        $('#totaldetapro').text('S/ ' + total.toFixed(2));
      },
    });
  }
  
  /**Fuera de servicio por que el admin desabilito la atención*/
  function fueraservicioadmin() {
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: {
        fueraservicioadmin: 1
      },
      success: function (data) {
        var estadolanding;
        var pedidominimo;
        var datoeach = JSON.parse(data);
        $.each(datoeach, function (ind, elem) {
          estadolanding = datoeach.estado;
          pedidominimo = datoeach.pedidominimo;
        });
        sessionStorage.setItem('pedidominimo', pedidominimo);
        if (estadolanding == 'i') {
          $(".mensjservi").removeClass('d-none');
          //$("#mensfuerser").hide();
          $(".btndesabilita").prop('disabled', true);
        } else {
          fueraserviciofecha();
          $(".mensjservi").addClass('d-none');
        }
      },
    });
  }
  
  /***Fuera de servicio por fecha, dia, hora***/
  function fueraserviciofecha() {
    var today = new Date();
    // obtener la fecha y la hora
    const dias = [
      'Domingo',
      'Lunes',
      'Martes',
      'Miercoles',
      'Jueves',
      'Viernes',
      'Sábado',
    ];
    const numeroDia = new Date(today).getDay();
    const nombreDia = dias[numeroDia];
    $.ajax({
      url: '../landing/action.php',
      method: 'POST',
      data: {
        fueraserviciofecha: 1, nombreDia: nombreDia
      },
      success: function (data) {
        var apertura;
        var cierre;
        var dia;
        if(!data){
          return console.log("falta configurar horario de atención");
        }
        var datoeach = JSON.parse(data);
        $.each(datoeach, function (ind, elem) {
          apertura = datoeach.apertura;
          cierre = datoeach.cierre;
          dia = datoeach.nombredia;
  
        });
        //console.log("Datos de BD: " + apertura, cierre, dia);
  
  
        //Mostrar hora cierre
        let indice3 = cierre.indexOf(":");
        let horacierre = cierre.substring(0, indice3);
        //Mostrar hora apertura
        let indice2 = apertura.indexOf(":");
        let horaapertura = apertura.substring(0, indice2);
        //mostrar solo la hora del sistema
        var now = today.toLocaleTimeString('en-US');
        let indice1 = now.indexOf(":");
        let horaSistema = now.substring(0, indice1);
  
        hora = today.getHours();
  
        //Obteniendo AM y PM de apertura y cierre
        var aperturaIndicador = apertura.substring(apertura.length - 2);
        var cierreIndicador = cierre.substring(cierre.length - 2);
  
  
        if (hora < 12) {
          if (aperturaIndicador == "AM" && cierreIndicador == "AM") {
            if (parseInt(horaSistema) >= parseInt(horaapertura) && parseInt(horaSistema) < parseInt(horacierre) && parseInt(horaapertura) >= 6) {
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
  
            } else {
              cerrosistemamensage(apertura, cierre);
  
            }
          }else if (aperturaIndicador == "AM" && cierreIndicador == "PM") {
            if (parseInt(horaSistema) >= parseInt(horaapertura)) {
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
  
            } else {
              cerrosistemamensage(apertura, cierre);
  
            }
          }else{
            cerrosistemamensage(apertura, cierre);
          }
  
        }else if (hora >= 12 && hora <= 24) {
  
          if (aperturaIndicador == "AM" && cierreIndicador == "AM") {
            if (parseInt(horaSistema) >= parseInt(horaapertura) && parseInt(horaSistema) < parseInt(horacierre) && parseInt(horaapertura) >= 6) {
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
  
            } else {
              cerrosistemamensage(apertura, cierre);
  
            }
          }
  
          if (aperturaIndicador == "AM" && cierreIndicador == "PM") {
            if(parseInt(horacierre)==parseInt(horaSistema)){
              cerrosistemamensage(apertura, cierre);
            }else if(parseInt(horaapertura)== parseInt(horaSistema)){
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
            }else if(parseInt(horaapertura)< parseInt(horaSistema)){
              abriosistemamensage(apertura, cierre);
            }else if(parseInt(horacierre) != 12 && parseInt(horaSistema) < parseInt(horacierre)) {
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
  
            } else {
              cerrosistemamensage(apertura, cierre);
            }
          }
  
          if (aperturaIndicador == "PM" && cierreIndicador == "PM") {
  
            if (parseInt(horaSistema) == parseInt(horaapertura)) {
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
  
            } else if(parseInt(horaSistema)< parseInt(horacierre)) {
              $(".contenedor-mensaje").removeClass('d-none');
              $(".btndesabilita").prop('disabled', false);
              $('#apertura').text(apertura);
              $('#cierre').text(cierre);
            }else {
              $(".mensfuerser").removeClass('d-none');
              $('#apert').text(apertura);
              $('#cierr').text(cierre);
              $(".btndesabilita").prop('disabled', true);
  
            }
          }
  
        }
  
        if (nombreDia.toString() != dia.toString()) {
          return;
  
        }
  
        //$("#pedidodetalle").html(data);
      },
    });
  }
  
  function cerrosistemamensage(apertura, cierre) {
    $(".mensfuerser").removeClass('d-none');
    $('#apert').text(apertura);
    $('#cierr').text(cierre);
    $(".btndesabilita").prop('disabled', true);
  }
  
  function abriosistemamensage(apertura, cierre) {
    $(".contenedor-mensaje").removeClass('d-none');
    $(".btndesabilita").prop('disabled', false);
    $('#apertura').text(apertura);
    $('#cierre').text(cierre);
  }

  function llenarTodosLosCampos(data) {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 2000,
        timerProgressBar: true,
        didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
    })

    Toast.fire({
        icon: 'warning',
        title: data
    })
}

let carritoPedido = [];
  function modalConfirmar() {
    var nombrecliente = $("#nombrecliente").val();
    var idemp = $("#idemp").val();
    var sede = $("#sede").val();
    var salon = $("#salon").val();
    var mesa = $("#mesa").val();
    carritoPedido = JSON.parse(localStorage.getItem("pedido")) || [];
    console.log(idemp + " , "+ sede + " , "+ mesa+ " , "+salon);
    console.log(carritoPedido);
    if(nombrecliente == ""){
      return llenarTodosLosCampos("Input nombre no puede estar vacio");
    }

    $.ajax({
      url: "../landing/action.php",
      method: "POST",
      data: {
          pedido_autoservic: 1,
          nombrecliente: nombrecliente,
          idemp:idemp, 
          sede: sede,
          salon: salon,
          mesa:mesa, 
          carritoPedido: carritoPedido
      },
      success: function (data) {
        console.log(data);
          if (data == 1) {
              mensaje('success','Pedido registrado');
              localStorage.clear();
              location. reload();
          }else{
            mensaje('error','No se pudo registrar');
          }
      }
    });
  }

  function mensaje(icon,msg){
    let timerInterval;
    const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 2000,
      timerProgressBar: true,
      didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
      }
    })
    Toast.fire({
        icon: icon,
        title: msg
    });
  }
  
  
  
  